# Post SMTP 3.6.1 Bug Fixes

## Issues Fixed

### 1. QRcode Fatal Error (Settings Page)
**Error**: `Call to undefined method QRcode::png()` when accessing Post SMTP settings page

**File**: `Postman/Mobile/mobile.php`  
**Line**: 142

**Problem**: The code was trying to include `qrlib.php` which doesn't contain the `QRcode` class. The class is actually in `phpqrcode.php`.

**Fix**: Changed the include path to use `phpqrcode.php` with `__DIR__` for absolute path resolution:
```php
// Before:
include_once 'includes/phpqrcode/qrlib.php';

// After:
include_once __DIR__ . '/includes/phpqrcode/phpqrcode.php';
```

### 2. createMailEngine() Fatal Error (Email Sending)
**Error**: `Call to a member function createMailEngine() on null` when sending emails

**File**: `Postman/PostmanWpMail.php`  
**Line**: 199-211

**Problem**: The code calls `createMailEngine()` on `$transport` without checking if it's null. This happens when no transport is configured or the transport registry fails to return an active transport.

**Fix**: Added null check before calling `createMailEngine()`:
```php
// Added after line 199:
// Check if transport is available before creating mail engine
if ( null === $transport ) {
    $this->logger->error( 'Post SMTP: No active transport configured. Please configure Post SMTP settings.' );
    $log->status = PostmanEmailLogService::STATUS_FAILED;
    $log->errorMessage = __( 'No active transport configured. Please configure Post SMTP settings.', 'post-smtp' );
    $log->save();
    return false;
}
```

## Testing

These fixes have been:
- ✅ Applied to local copy in `shared/plugins/post-smtp-3.6.1/`
- ✅ Uploaded and syntax-checked on hirugaesu.com
- ✅ Ready for testing on live site

## Installation

To apply these fixes to a site:

1. Upload the patched files:
   - `Postman/PostmanWpMail.php`
   - `Postman/Mobile/mobile.php`

2. Or use the files from `shared/plugins/post-smtp-3.6.1/`

## Notes

- These are plugin file modifications and will be overwritten on plugin updates
- Consider reporting these issues to Post SMTP developers
- The fixes are backward compatible and don't change plugin functionality

